/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.api.tileentity.ISidedTexture;
import cofh.core.block.TileCoFHBase;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;

public class TileFont
extends TileCoFHBase
implements ISidedTexture {
    Block baseBlock = Blocks.bedrock;
    IIcon icon = Blocks.bedrock.getBlockTextureFromSide(0);
    Fluid fluid;
    BlockFluidBase fluidBlock;
    int amount = -1;
    int productionDelay = 100;
    long timeTracker;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileFont.class, (String)"cofh.Font");
    }

    public boolean setFluid(Fluid fluid) {
        if (fluid.getBlock() != null) {
            this.fluid = fluid;
            this.fluidBlock = (BlockFluidBase)fluid.getBlock();
            return true;
        }
        return false;
    }

    public boolean setAmount(int n) {
        if (n > 0) {
            this.amount = n;
            return true;
        }
        return false;
    }

    public boolean setBaseBlock(Block block) {
        if (block != null) {
            this.baseBlock = block;
            return true;
        }
        return false;
    }

    public boolean setIcon(IIcon iIcon) {
        if (iIcon != null) {
            this.icon = iIcon;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "tile.cofh.font.name";
    }

    @Override
    public int getType() {
        return 0;
    }

    public void update() {
        long l = this.worldObj.getTotalWorldTime();
        if (this.timeTracker >= l) {
            return;
        }
        this.timeTracker = l + (long)this.productionDelay;
        int n = this.xCoord;
        int n2 = this.yCoord;
        int n3 = this.zCoord;
        int n4 = this.worldObj.getBlockMetadata(n, n2, n3);
        ForgeDirection forgeDirection = ForgeDirection.getOrientation((int)(n4 ^ 1));
        if (this.fluidBlock.canDisplace((IBlockAccess)this.worldObj, n + forgeDirection.offsetX, n2 + forgeDirection.offsetY, n3 + forgeDirection.offsetZ)) {
            this.worldObj.setBlock(n + forgeDirection.offsetX, n2 + forgeDirection.offsetY, n3 + forgeDirection.offsetZ, (Block)this.fluidBlock, 0, 3);
            this.worldObj.notifyBlockChange(n + forgeDirection.offsetX, n2 + forgeDirection.offsetY, n3 + forgeDirection.offsetZ, this.getBlockType());
            if (this.amount > 0) {
                --this.amount;
            }
            if (this.amount == 0) {
                this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, n4 | 8, 2);
            }
        }
    }

    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        super.readFromNBT(nBTTagCompound);
    }

    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        super.writeToNBT(nBTTagCompound);
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        return this.icon;
    }
}

